


/***********************************************************************************************
 *                                                                                             *
 *                        Example_1. ET-REMOTE MP3 COMMAND-Mode By Sent Command                *
 *                                                                                             *
 ***********************************************************************************************
 *  Target MCU    : LPC2138 (CP-JRARM7 LPC2138)                                                *
 *       	       : X-TAL : 19.6608 MHz                                                       * 
 *                : PLL Setup = M(3),P(2)	                                                   *
 *                : Run Speed 58.9824 MHz(With PLL)(19.6608MHz x 3 = 58.9824 MHz               *         
 *                : VPB Clock(pclk) = CPU Clock/2 = 58.9824MHz/2 = 29.4912 MHz                 *
 *                : CPU Clock(cclk) = 58.9824 MHz                                              *           
 *                                                                                             *
 * Editor         : uVision3 (V3.60)                                                           *
 * Compiler       : RealView MDK-ARM 3.20        						                       * 
 * Port Interface :                                                                            *
 *																			                   *
 *                : # MCU-ARM7 LPC2138 #                    # ET-REMOTE MP3 #                  *
 *                  --------------------                    -----------------                  *
 * UART0(RS232)   :      P0.1(Rx0)             Connect            Tx                           *
 *                       P0.0(Tx0)             Connect            Rx			               *
 *                       GND                   Connect           GND						   *
 *            	         Baud Rate 9600                                                        *
 * 																				               *
*              3.3V                                                                            *
 *             -+-                                                                             *
 *              |                                                                              *
 *              +------------------+                                                           *
 *              |                  |                                      -DIP SW.MODE         *
 *              |                  |                                       S1=ON ; S2=ON       *
 *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG       *
 *       +------+------+           |               +-------------------+   S1=ON ; S2=OFF      *
 *       |             |       +---+---+   +---+   |                   |   BR:9600             *
 *       |             |       |       |   |   |   |RS232(have-Max232) |                       *
 *       |             | RX0   |       |   |   |   |----+              |                       *
 *       |         P0.1+-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|             *   
 *       |             | TX0   |       |   | |     |   ||              |      /  |             *
 *       |         P0.0+-------|TxI TxO|---+ +-----|*Tx||              +----||   |             *
 *       |             |       |       |           |   ||              |    || SP|             *
 *       |             |       |MAX232 |       +---+*G ||              +----||   |             *
 *       |             |       +---+---+       |   |----+   [Power]    |      \  |             *
 *       |ARM7-LPC2138 |           |           |   |                   |        \|             * 
 *       +------+------+           |           |   |         G  5V     |                       *
 *              |                  |           |   +---------+---+-----+                       * 
 *              |                  |           |             |   |                             *
 *              +------------------+-----------+             |   +--->5V                       *
 *              |                                            |                                 *
 *            --+--                                        --+--                               *
 *             ---                                          ---                                *
 *              -                                            -                                 *
 *                                                                                             *
 * Test Operate    : For Test Program in Micro SD Card must have number File 15 File           *
 *                   Play File Numbe 1 once and Play Repeat File Number 2-15                   *
 *                                                                                             *
 * Last Update     : 8/June/2012                                                               *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/


  
#include "LPC213x.h" 	                             
#include "stdio.h"

 char num_hi,num_lo  ;       //Keep Ascii byte high and low

 /*************************************
  *         External Function         *
  *************************************/

extern int  sendchar(int ch)   ;  //Function Tx in Serial.c 
extern int  getkey(void)       ;  //Function Rx in Serial.c 
  
 
 /***********************************************
  *                 Function Delay 		        *
  ***********************************************/
 void delay(int cnt)
 {
  int i,j ;
  
      for(i=0;i<cnt;i++)
	    for(j=0;j<cnt;j++);
 }

 
 /*********************************************
  *              Initial UART0                *
  *********************************************
  *      Initial UART0 = 9600,N,8,1 		  *
  *        VPB(pclk)   = 29.4912 MHz    	  *
  *     U0DLM:U0DLL    = 29.4912MHz/[16xBaud] *
  *                    = 26.4912MHz/[16x9600] *
  *                    = 192=0x00C0     	  *
  *********************************************/

 void UART0_Init(void)
  {
    //--------- Initial Uart0 ----------
   
	U0LCR        = 0x83                     ;  //Conroll Uart1:8bit,1stop,None parity,enable Divisor Latch (83)
    U0DLM        = 0x00                     ;  // Program Divisor Latch  for Baud Rate 9600 ,BR:Byte High  
	U0DLL        = 0xC0                     ;  // BR:Byte Low
    U0LCR        = 0x03                     ;  //Diadble Divisor Latch   
    U0IER        = 0x00000001               ;  //Enable RDA Int(Rx).	
	U0FCR        = 0x07                     ;  //Control Uart0 FIFO:FIFO Enable,Reset Tx,Rx FIFO

  }

 
/***********************************************************
 **                     Initial Port                      **
 ***********************************************************/
 
 void Init_Port(void)
  {
  //------ Set GPIO  PIN -------

  PINSEL0 = 0x00000005               ;	   //Set Port0-PIN[2..15] = GPIO;Enable RxD0(P0.1) and TxD0(P0.0)
 
  } 

  
 
/*************************************************************************************
 **                 Check Respond Command & End of Fili From Board MP3              **
 *************************************************************************************/

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm()
 {
   char buf_cmm[2] ;
   char n,ch ;
   
   do
    {
      do
       {  
         ch = getkey()  		        ; //Read Data
		 
       }while(ch != '#')                ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                    //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         buf_cmm[n] = getkey()          ; //Keep Data 'OK' 
       }
     
    }while((buf_cmm[0]!='O')&&(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }


//-------------- Check Echo End Of File(&E) ---------------

void Echo_EOF()
 {  
   unsigned char eof,ch ;
   
   do
    {
      do
       {
         ch = getkey()                        ;  //Read Data
  
	   }while(ch != '&')                      ;  //Check Byte Start of Echo EOF('&')

       eof = getkey()                         ;  //Read Data 
 
    }while(eof!='E')                          ;  //Check Echo EOF = 'E' Exit loop
 }


 /****************************************************************
  *         Function Convert Dec(01-99) To Ascii 2 Colume  	     *
  ****************************************************************/

void Dec_to_Ascii(char num_fi)
 {
   if(num_fi <= 99)
    {
      num_hi = (num_fi/10)+0x30   ; //Convert to Ascii Byte High
      num_lo = (num_fi%10)+0x30   ; //Convert to Ascii Byte Low 
    }
 }


/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/


int main(void) 
 {
   char num,enter  = 0x0D  ;

	Init_Port()                    ;
    UART0_Init()                   ;
    delay(800)                     ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------

    printf("*CF=000%c",enter)      ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,0:Not Display Time
	Echo_Cmm()                     ;   //Check CMM'#OK'
  
    printf("*VL=60%c",enter)       ;   //Sent CMM Set Volum='60'
    Echo_Cmm()                     ;   //Check CMM'#OK'

    printf("*P1=01%c",enter)       ;   //Sent CMM Play File by Number :Start File #1
    Echo_Cmm()                     ;   //Check CMM'#OK'

    Echo_EOF()                     ;   //Check End of File
    

   //------------- Loop Play file Number #2-#15 Repeat All  -----------
    
   num = 2                                      ;  //Value for Number Song Decimal
   while(1)
     {

      Dec_to_Ascii(num)                         ;   //Convert Number File to Ascii

      printf("*P1=%c%c%c",num_hi,num_lo,enter)  ;   //Sent CMM Play File by Number :Start File #2
	  Echo_Cmm()                                ;   //Check CMM'#OK'

      Echo_EOF()                                ;   //Check End of File
      num++                                     ;   //Increment Next Number File
 
      if(num==16)                                   //Check File Last number 15
         num = 2                                ;   //New Start File Number 2 
     }    
 
  }

 












